import javax.swing.*;
import java.awt.event.*;
import java.io.*;

public class Aplikacja extends JFrame {
  private JTextArea textArea;
  private JButton buttonSave, buttonLoad;
  private JLabel label;
  private JTextField textField;
  public Aplikacja() {
    ActionListener al = new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(e.getSource() == buttonSave){
          save();
        } else if(e.getSource() == buttonLoad){
          load();
        }
      }
    };
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setLayout(null);

    textArea = new JTextArea();
    textArea.setBounds(30, 10, 260, 200);
    this.add(textArea);

    label = new JLabel("Plik:");
    label.setBounds(30, 220, 40, 20);
    
    textField = new JTextField();
    textField.setBounds(60, 220, 230, 20);
    
    buttonSave = new JButton("Zapisz");
    buttonSave.setBounds(50, 260, 100, 20);
    buttonSave.addActionListener(al);
    
    buttonLoad = new JButton("Wczytaj");
    buttonLoad.setBounds(160, 260, 100, 20);
    buttonLoad.addActionListener(al);

    add(textArea);
    add(buttonSave);
    add(buttonLoad);
    add(label);
    add(textField);

    setSize(320, 320);
    setVisible(true);
  }
  public void save() {
    FileWriter fileWriter = null;
    String text = textArea.getText();

    try{
      fileWriter = new FileWriter(textField.getText(), true);
      fileWriter.write(text, 0, text.length());
      fileWriter.close();
    }
    catch(IOException e){
      //System.out.println("Bd podczas zapisu pliku.");
    }
  }
  public void load() {
    BufferedReader brIn = null;
    try{
      brIn = new BufferedReader(
        new FileReader(textField.getText())
      );
    }
    catch(FileNotFoundException e){
      //System.out.print("Brak wskazanego pliku.");
      return;
    }

    String line = "";

    try{
      while((line = brIn.readLine()) != null){
        textArea.append(line + "\n");
      }
      brIn.close();
    }
    catch(IOException e){
      //System.out.println("Bd podczas odczytu pliku.");
    }
  }
  public static void main(String args[]) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new Aplikacja();
      }
    });
  }
}
